<?php
## phpFe_admin - phpFe administrator addon
## by Victor Hallberg [http://mogel.nu]
## Copyright (c) 2007-2010 Victor Hallberg
## Last update: 2010-04-20
define('PHPFE_ADMIN_VERSION', '0.4.5');

// Kill execution if called outside phpFe.php
if (!defined('PHPFE_VERSION')) die();
// Initiate session
session_start();

// Log out if requested
if (isset($_GET['logout'])):
	unset($_SESSION['phpFe_admin']); $admin = false; return false; die();
endif;

## {{{ CONFIGURATION
## Editable settings

	// Administrator authentication password -------------------vvv
	if (isset($_GET['login']) && md5 ($_GET['login']) == md5 ('password'))
		$_SESSION['phpFe_admin'] = true;

	// Abort if user is not logged in (don't mind this)
	if (!isset($_SESSION['phpFe_admin'])):
		$admin = false; return false; die();
	endif;

	// Optional: Set the maximal upload size allowed(in bytes)
	// If omitted the value will be imported from the PHP server settings
	#$post_max_size = 5 * 1048576; // 5mb

	// Comment to disable automatically showing the goto & search boxes when logged in as admin
	$search['enabled'] = true;

	// Comment to keep exclude filters browsing as admin
	$excludes = array();

	// Edit: Disable admin privileges(just show all files and enable search for admins)
	$admin = false;

	// Unomment to output admin panel before the object listing
	#define('APANEL_FIRST', 1);

## }}} CONFIGURATION

## {{{ OPERATIONS HANDLING
## Handling of userinitiated actions

// Clean up _POST variables
strip_magicquotes($_POST);
clean_patharray($_POST['cl_obj']);

// Get maximum _POST size(most important for upload size limits) unless specified
if (!isset($post_max_size)):
	$post_max_size = trim(ini_get('post_max_size'));
	switch (strtolower($post_max_size{strlen($post_max_size)-1})) {
		case 'g': $post_max_size *= 1024;
		case 'm': $post_max_size *= 1024;
		case 'k': $post_max_size *= 1024;
	}
endif;

// Shorthand variablenames
$aobj =& $_POST['cl_obj'];

## {{{  RENAME(SINGLE/BATCH)
if (isset($_POST['rename_submit']) && is_array($aobj) && !empty($_POST['rename'])):

	## {{{ Rename single object
	if (count($aobj) < 2 && !@rename(dROOT.BASEPATH.$aobj[0], dROOT.BASEPATH.dirname($aobj[0]).'/'.$_POST['rename'])):
		$msg[] = 'Failed to rename "'.$aobj[0].'" to "'.$_POST['rename'].'".';
	elseif(count($aobj) < 2):
		$aobj[0] = dirname($aobj[0]).'/'.$_POST['rename'];
	## }}} Rename single object
	## {{{ Batch rename(rename multiple objects with a numbersequence separating them)
	else:
		// Number of objects to batch rename
		$num = count($aobj);
		$numlen = strlen((string)$num);
		// Batch rename each object
		for ($i = 0; $i < $num; ++$i):
			// Attempt to rename current object
			$obj_name = obname($aobj[$i]);
			$rnewname = $_POST['rename'].str_pad($i+1, $numlen, '0', STR_PAD_LEFT).
				(strrpos($obj_name, '.') !== false && @is_file(dROOT.BASEPATH.$aobj[$i]) ? substr($obj_name, strrpos($obj_name, '.')) : '');
			if (!@rename(dROOT.BASEPATH.$aobj[$i], dROOT.BASEPATH.dirname($aobj[$i]).'/'.$rnewname)):
				$msg[] = 'Failed to rename "'.$obj_name.'" to "'.$rnewname.'".';
			// Remove successfully moved object from queue
			else: $aobj[$i] = $rnewname;
			endif;
		endfor;
	endif;
	## }}} Batch rename

## {{{  CHMOD
elseif(isset($_POST['chmod_submit']) && is_array($aobj) && !empty($_POST['chmod'])):
	
	// Validate chmod value
	if (preg_match('~[^0-7]~', $_POST['chmod'])):
		$msg[] = 'Invalid chmod value('.$_POST['chmod'].').';
	else:
		$chmod = octdec('0'.$_POST['chmod']);
		// Parse objects array
		$num = count($aobj);
		for ($i = 0; $i < $num; ++$i):
			// Attempt to chmod current object
			if (!@chmod(dROOT.BASEPATH.$aobj[$i], $chmod))
				$msg[] = 'Failed to chmod "'.obname($aobj[$i]).'".';
			// Remove successfully moved object from queue
			else unset($aobj[$i]);
		endfor;
	endif;

## {{{  CREATE DIRECTORY
elseif(isset($_POST['mkdir_submit']) && (!empty($_POST['dirname']) || $_POST['dirname'] == '0')):
	
	$cdirname = $_POST['dirname'];
	######### Make sure that the directory name is valid
	if (preg_match('~[\\\/\:\*\|\"\<\>]~', $cdirname)):
		$msg[] = 'The directory name specified is invalid, no directory was created.';
	######### Check if the directory already exists
	elseif(@file_exists(dROOT.BASEPATH.$path.$cdirname)):
		$msg[] = 'Cannot create a directory named "'.$cdirname.'", a directory with the same name already exists in the target location.';
	######### Attempt to create the directory
	elseif(!@mkdir(dROOT.BASEPATH.$path.$cdirname)):
		$msg[] = 'An error occured while attempting to create the directory "'.$cdirname.'" in "'.BASEPATH.$path.'"';
	######### Directory created, clear form data
	else: unset($_POST['dirname'], $_POST['mkdir_submit']);
	endif;

## {{{  CUT / COPY
elseif( (isset($_POST['cut']) || isset($_POST['copy'])) && is_array($aobj) && count($aobj) > 0 ):

	// Save selected directories and/or files to session
	$_SESSION['phpFe_action'] = (isset($_POST['cut']) ? 'cut' : 'copy');
	$_SESSION['phpFe_origin'] = $path;
	$_SESSION['phpFe_curr_obj'] = $aobj;

## {{{  PASTE(FROM CUT)
elseif(isset($_POST['paste']) && $_SESSION['phpFe_action'] =='cut' && is_array($_SESSION['phpFe_curr_obj'])):
	
	// Shorthand variablename for session objects
	$saobj = $_SESSION['phpFe_curr_obj'];

	## {{{ Parse objects array
	$num = count($saobj);
	for ($i = 0; $i < $num; ++$i):
		$obj_name = obname($saobj[$i]);
		// Skip current object if target already exists
		if (@file_exists(dROOT.BASEPATH.$path.$obj_name)):
			$msg[] = 'Cannot move "'.$obj_name.'" to "'.$path.'", the target already exists.';
		// Attempt to move current object to destination
		elseif(!@rename(dROOT.BASEPATH.$saobj[$i], dROOT.BASEPATH.$path.$obj_name)):
			$msg[] = 'An error occured while moving "'.$obj_name.'" to "'.$path.'".';
		endif;
	endfor;
	## }}} Parse objects array

	// Clear session data
	unset($_SESSION['phpFe_action'], $_SESSION['phpFe_curr_obj'], $_SESSION['phpFe_origin'], $saobj);

## {{{  PASTE(FROM COPY)
elseif(isset($_POST['paste']) && $_SESSION['phpFe_action'] == 'copy' && is_array($_SESSION['phpFe_curr_obj'])):

	// Shorthand variablename for session objects
	$saobj = $_SESSION['phpFe_curr_obj'];

	## {{{ Parse objects array
	for ($i = 0; $i < count($saobj); ++$i):
		// Extract name of the object
		$obj_name = obname($saobj[$i]);
		$obj_targetpath = preg_replace('~^'.preg_quote($_SESSION['phpFe_origin'], '~').'~i', $path, $saobj[$i]);
		// Skip current object if target already exists
		if (@file_exists(dROOT.BASEPATH.$obj_targetpath)):
			$msg[] = 'Cannot copy "'.$obj_name.'" to "'.$obj_targetpath.'", the target already exists.';
		else:

			## {{{ Current object is a directory
			if (@is_dir(dROOT.BASEPATH.$saobj[$i])):
				// Create the directory at the target destination
				if (!@mkdir(dROOT.BASEPATH.$obj_targetpath)):
					$msg[] = 'Cannot create /'.$obj_name.'/ in "'.$obj_targetpath.'", most likely due to permissions not allowing it.';
				else:
					// Attempt to open directory & add its files & subfolders to the queue
					$d = @opendir(dROOT.BASEPATH.$saobj[$i]);
					if ($d): while ((false !== $pobject = @readdir($d))):
						if ($pobject == '.' || $pobject == '..') continue;
						$saobj[] = $saobj[$i].$pobject.(@is_dir(dROOT.BASEPATH.$saobj[$i].$pobject) ? '/' : '');
					endwhile;
					@closedir($d); endif;
				endif;
			## }}} Current object is a directory
			## {{{ Current object is a file - attempt to copy it to the destination
			elseif(!@copy(dROOT.BASEPATH.$saobj[$i], dROOT.BASEPATH.$obj_targetpath)):
				$msg[] = 'An error occured while copying "'.$obj_name.'" to "'.$obj_targetpath.'".';
			endif;
			## }}} Current object is a file

		endif;
	endfor;
	## }}} Parse objects array

	// Clear session data
	unset($_SESSION['phpFe_action'], $_SESSION['phpFe_curr_obj'], $_SESSION['phpFe_origin'], $saobj);

## {{{  DELETE
elseif(isset($_POST['delete']) && is_array($aobj)):

	// Directory placeholder array
	$deldirs = array();

	## {{{ Parse objects array
	$successful = 0;
	for ($i = 0; $i < (count($aobj) + $successful); ++$i):
		// Don't even try if current object doesn't exist
		if (@file_exists(dROOT.BASEPATH.$aobj[$i])):

			// Extract name of the object
			$obj_name = obname($aobj[$i]);

			## {{{ Current object is a directory
			if (@is_dir(dROOT.BASEPATH.$aobj[$i])):
				// Attempt to open directory & add its files & subfolders to the queue
				$d = @opendir(dROOT.BASEPATH.$aobj[$i]);
				if ($d): while ((false !== $dobject = @readdir($d))):
					if ($dobject == '.' || $dobject == '..') continue;
					$aobj[] = $aobj[$i].$dobject.(@is_dir(dROOT.BASEPATH.$aobj[$i].$dobject) ? '/' : '');
				endwhile;
				@closedir($d); endif;
				// Add current directory to the queue for deletion
				array_unshift($deldirs, $aobj[$i]);
			## }}} Current object is a directory
			## {{{ Current object is a file - attempt to delete it
			elseif(!@unlink(dROOT.BASEPATH.$aobj[$i])):
					$msg[] = 'An error occured while deleting "'.$obj_name.'".';
			// Remove successfully moved object from queue
			else: unset($aobj[$i]); ++$successful;
			endif;
			## }}} Current object is a file
		
		endif;
	endfor;
	## }}} Parse objects array

	## Remove directories now that they should be empty
	if (!empty($deldirs)): foreach ($deldirs as $dir)
		if (!@rmdir(dROOT.BASEPATH.$dir)) $msg[] = 'An error occured while deleting "'.$obj_name.'".';
	endif;

	// Clear selection data
	unset($aobj);

## {{{  UPLOADS
elseif(!empty($_FILES)):
	
	## {{{ Loop through each uploaded file
	foreach ($_FILES as $num => $file):

		// Skip empty files
		if (empty($file['name'])) continue;
		// Destination
		$fdest = dROOT.BASEPATH.$path.$file['name'];

		// Check if file already exists
		if (@file_exists($fdest) && $_POST['overwrite'] != 'on'):
			$msg[] = 'Could not upload "'.$file['name'].'", a file with the same name already exists in the target location.';
		// Make sure that the file(s) is/are not too big
		elseif($file['error'] == UPLOAD_ERR_INI_SIZE || $file['error'] == UPLOAD_ERR_INI_SIZE):
			$msg[] = 'Failed to upload "'.$file['name'].'", the total file size exceeds what is allowed.';
		// Attempt to move upload if no errors occured
		elseif($file['error'] == UPLOAD_ERR_OK && !@move_uploaded_file($file['tmp_name'], $fdest)):
			$msg[] = 'Failed to upload "'.$file['name'].'".';
		endif;

	endforeach;
	## }}} Loop through each uploaded file

## }}} OPERATIONS HANDLING
endif;


## {{{ strip_magicquotes
## Strip out magic quotes from array if enabled
function strip_magicquotes(&$array) {
	if (!get_magic_quotes_gpc() || !is_array($array)) return true;
	foreach ($array as $key => $value):
		if (is_array($value)) strip_magicquotes($array[$key]);
		else $array[$key] = stripslashes($value);
	endforeach;
} ## }}} strip_magicquotes

## {{{ clean_patharray
## Remove invalid paths from array
function clean_patharray(&$paths) {
	if (empty($paths) || !is_array($paths)) $paths = array();
	foreach ($paths as $key => $path)
		if (@strpos($path, '../') !== false) unset($paths[$key]);
} ## }}} clean_patharray


## {{{ admin_pre_table
## Output markup before the table list data
function admin_pre_table() {
?>
<form id='form_admin' method='post' enctype='multipart/form-data' action='<?php echo entity($_SERVER['REQUEST_URI']) ?>'>
<?php
if (defined('APANEL_FIRST')) admin_form();
} ## }}} admin_pre_table

## {{{ admin_post_table
## Output markup after the table list data
function admin_post_table() {
if (!defined('APANEL_FIRST')) admin_form();
?>
</form>
<?php
} ## }}} admin_post_table

## {{{ admin_form
## Write markup for the admin panel along with any messages
function admin_form() {

// Insert chmod value for first selected object if requested
if (!empty($_POST['cl_obj'][0]) && (isset($_POST['chmod_insert']) || isset($_POST['chmod_submit']) ) )
	$chmod = substr(sprintf('%o', @fileperms(dROOT.BASEPATH.$_POST['cl_obj'][0])), -3);
// Insert name input value for first selected object if the form has been submitted
if (!empty($_POST['cl_obj'][0]) && isset($_POST['rename_submit'])):
	$firstobj = obname($_POST['cl_obj'][0]);
	$rename = (count($_POST['cl_obj']) < 2 && strrpos($firstobj, '.') !== false) ? $firstobj : substr($firstobj, 0, strrpos($firstobj, '.'));
endif;
// Show directory creation panel if requested
$show_createdir = (isset($_POST['dircreate_submit']) || isset($_POST['mkdir_submit']) ? true : false);

?>

<?php if ($show_createdir): ?>
<div class='box' id='mkdir_box'>
<h2><label>Create directory</label></h2>
	<fieldset id='form_mkdir'>
		<input type='submit' class='button compact' name='back_submit' id='back_submit' value='&lt;' title='Cancel directory creation' />
		<input type='text' class='textbox' name='dirname' id='dirname' title='Directory name' value='<?php echo(isset($_POST['dirname']) ? $_POST['dirname'] :'') ?>' />
		<input type='submit' class='button' name='mkdir_submit' id='mkdir_submit' value='Create directory' />
	</fieldset>
</div>
<?php else: ?>
<div class='box' id='rename_box'>
<h2><label>Rename</label></h2>
	<fieldset id='form_rename'>
		<input type='text' class='textbox' name='rename' id='rename' title='New name' value='<?php echo $rename ?>' />
		<input type='submit' class='button' name='rename_submit' id='rename_submit' value='Rename' />
</div>
<div class='box' id='chmod_box'>
<h2><label>Chmod</label></h2>
	<fieldset id='form_chmod'>
		<input type='submit' class='button compact' name='chmod_insert' id='chmod_insert' value='&gt;' title='Insert selected' />
		<input type='text' class='textbox' name='chmod' id='chmod' title='Chmod value' maxlength='3' value='<?php echo $chmod ?>' />
		<input type='submit' class='button' name='chmod_submit' id='chmod_submit' value='Chmod' />
	</fieldset>
</div>
<?php endif ?>

<div class='box' id='upload_box'>
<h2><label for='multifile'>Upload</label></h2>
	<fieldset id='form_upload'>
		<input type='hidden' name='MAX_FILE_SIZE' value='<?php echo $post_max_size ?>' />
		<input type='file' class='file' name='multifile' id='multifile' />
		<input type='submit' class='button' name='upload' id='upload_submit' value='Upload' />
		<label for='overwrite' class='chklabel'><input type='checkbox' class='chk' name='overwrite' id='overwrite' />Overwrite</label>
		<span id='uplnote'>Upload size limit: <?php echo convert_filesize($GLOBALS['post_max_size']) ?></span>
	</fieldset>
</div>

<div class='box' id='modify_box'>
<h2><label>Modify</label></h2>
	<fieldset id='form_modify'>
		<input type='submit' class='button' name='dircreate_submit' id='dircreate_submit' value='Create dir' title='Create directory' />
		<span class='separator'>&nbsp;</span>
		<input type='submit' class='button' name='cut' id='cut_submit' value='Cut' />
		<input type='submit' class='button' name='copy' id='copy_submit' value='Copy' />
		<input type='submit' class='button' name='paste' id='paste_submit' value='Paste'<?php echo(empty($_SESSION['phpFe_curr_obj']) ? " disabled='disabled'" :'') ?> />
		<span class='separator'>&nbsp;</span>
		<input type='submit' class='button' name='delete' id='delete_submit' value='Delete' />
	</fieldset>
</div>

<?php
} ## }}} admin_form

## {{{ admin_firstcol
## Write checkbox column markup
function admin_firstcol() {
?>	<th id='col_check'<?php echo($sort_by==$columns[0] ? " class='active'" :'') ?>><input type='checkbox' class='chk' name='chktoggle' id='chktoggle' value='' /></th>
<?php
} ## }}} admin_firstcol

if ($admin):
## {{{ output_list
## Replacement function to include checkboxes
function output_list(&$list, $is_dirs = false) {
	global $columns;
	if (count($list) < 1) return false;

	// Output each objects data
	foreach ($list as $num => $obj):
		$obj_path = entity($obj['path']);
		$is_checked = (!empty($_POST['cl_obj']) && in_array($obj['path'], $_POST['cl_obj']) ? " checked='checked'" : '');
		echo "<tr class='".($is_dirs?'d':'f ft_'.$obj['type'])."'>";
		//Admin checkboxes
		echo "<td class='chk'><input type='checkbox' class='chk' name='cl_obj[]' value='".$obj_path."'".$is_checked." /></td>";
		foreach ($columns as $num => $col):
			if ($num == 0) echo "<td class='n'><a href='".req_url($obj['path'])."' title='".$obj_path."'>".$obj[$col]."</a></td>";
			else echo "<td>".(isset($obj[$col.'_disp'])?$obj[$col.'_disp']:$obj[$col])."</td>";
		endforeach;
		echo "</tr>\n";
	endforeach;

} ## }}} output_list
endif;

