/*#####################################
//## phpFe - PHP File explorer
//## Admin javascript file
//#####################################
*/

// "Toggle all" support for checkboxes
function chkToggle(checkboxId) {
	var toggleCheckbox = document.getElementById(checkboxId);
	toggleCheckbox.onclick = function() {
		var theForm = this.form, f = 0;
		for (f = 0; f < theForm.length; f++)
			if (theForm[f].type == 'checkbox' && theForm[f].name.substr(0, 3) == 'cl_')
				theForm[f].checked = this.checked;
	};
}

// Allow multiple uploads with one visible file input
function multiFile(targetId) {
	var targetInput = document.getElementById(targetId);
	var inputParent = targetInput.parentNode;
	var cid = 0;

	// Create select(list) box
	var listBox = document.createElement('select');
	listBox.size = 1;
	listBox.id = targetId + '_list';
	inputParent.insertBefore(listBox, targetInput.nextSibling);
	// Create delete button
	var deleteButton = document.createElement('input');
	deleteButton.type = 'button';
	deleteButton.id = targetId + '_delete';
	deleteButton.value = 'x';
	deleteButton.onclick = function() {
		// Remove selected file input
		var input_field = document.getElementById(listBox.options[listBox.selectedIndex].value);
		if (input_field.parentNode.removeChild(input_field))
		listBox.remove(listBox.selectedIndex);
		return false;
	};
	inputParent.insertBefore(deleteButton, listBox.nextSibling);

	// Add file input
	this.addFile = function(element) {
		if (element.type == 'file') {
			element.name = targetId + cid++;
			element.id = element.name;
			element.multiFile = this;
			element.onchange = function() {
				// Event to add another file input when the current has gotten input
				var new_element = document.createElement('input');
				new_element.type = 'file';
				inputParent.insertBefore(new_element, listBox);
				this.multiFile.addFile(new_element);
				this.multiFile.addListRow(this);
				this.style.position = 'absolute';
				this.style.left = '-10000px';
				this.style.display = 'none';
			};
		};
	};
	
	// Add file to list row
	this.addListRow = function(element) {
		var new_row = document.createElement('option');
		var fn = element.value.split('\\');
		fn = fn[fn.length-1].split('/');
		fn = fn[fn.length-1];
		new_row.text = fn;
		new_row.value = element.id;
		new_row.selected = 'selected';
		try { listBox.add(new_row, null); }
		catch(ex) { listBox.add(new_row); }
	};

	this.addFile(targetInput);
};

// Initiate scripts on page load
window.onload = function() {
	multiFile('multifile');
	chkToggle('chktoggle');
}
