<?php
## phpFe - PHP File explorer
## by Victor Hallberg [http://mogel.nu]
## Copyright (c) 2005-2010 Victor Hallberg
## Last update: 2010-04-20
define('PHPFE_VERSION', '0.7.5');

## {{{ CONFIGURATION
## Editable settings

	## {{{ PATH SETTINGS
	## All paths should begin with a forward slash (/) unless empty

	// Base path relative to server root
	define('BASEPATH', '');

	// Path to phpFe.php (and if enabled, phpFe_admin.php aswell)
	// phpFe can most likely figure this by itself
	$script_path = dirname($_SERVER['SCRIPT_NAME']);
	if ($script_path == '\\' || $script_path == '/') $script_path = '';
	// Path to the phpFe folder (where the css and img folders are located)
	$folder_path = $script_path.'';

	## }}} PATH SETTINGS
	## {{{ URL/NAVIGATION SETTINGS

	// Path phpFe should use to query itself
	// Set to $_SERVER['SCRIPT_NAME'] or a custom URL if using mod_rewrite
	#$queryURL = $_SERVER['SCRIPT_NAME'];
	$queryURL = '/f';

	// Use friendly URLs instead of passing path by querystring?
	// Requires mod_rewrite or the PathInfo variable to be enabled on the server
	$useFURL = true;

	// Enable/disable use of relative paths to shorten URLs in the output
	$useRelURLs = true;

	// Disable navigation - phpFe links directly to the objects listed if turned off
	// Uncomment to turn navigation off
	#define(NONAV, 1);

	## }}} URL SETTINGS
	## {{{ MISCELLANEOUS SETTINGS
	
	// Enable/disable phpFe administrator addons; phpFe_admin.php
	$admin = false;

	// Enable/disable searching and the goto textbox
	$search['enabled'] = true;
	// Enable/disable use of Regular Expressions in searches
	$search['regex'] = true;

	// RegEx patterns which phpFe should exclude from listing (hide)
	$excludes = array(
		'^'.preg_quote($folder_path, '~'),
		'/\.',
		'^/robots.txt',
	);

	// Columns to show
	$columns = array('name', 'type', 'size', 'date');

	// Disable listing of files first when sorting descending
	// Uncomment to list directories first even when sorting descending
	#define('DIRS_FIRST', 1);

	// Time formatting
	$timeFormat = 'Y-m-d H:i';

	## }}} MISCELLANEOUS SETTINGS

## }}} CONFIGURATION


## {{{ RETRIEVE AND GENERATE PATH VARIABLES
## Retrieve requested path and redirect if necessary

	### Clean up _GET variables
	if (get_magic_quotes_gpc() && is_array($_GET))
		foreach ($_GET as $key => $value) $_GET[$key] = stripslashes($value);
	if (!isset($_GET['s'])) $_GET['s'] = null;
	$msg = array();

	## Retrieve and generate path variables
	$path = (isset($_GET['p']) ? $_GET['p'] : preg_replace('~^('.preg_quote($queryURL, '~').')?([^\?]*)(.*)~', '\\2', $_SERVER['REQUEST_URI']));
	define('dROOT', $_SERVER['DOCUMENT_ROOT']);
	if ($path == $_SERVER['SCRIPT_NAME']) $path = '';
	$path = '/'.trim(str_replace(array('../', './'), '', trim($path)), '/');
	if (substr($path, -1) != '/' && @is_dir(dROOT.BASEPATH.$path)) $path .= '/';
	if (!preg_match('~^'.preg_quote($queryURL, '~').'~', $_SERVER['REQUEST_URI'])) $useRelURLs = false;

	######### Forward if requsted path points to a file
	if (!is_dir(dROOT.BASEPATH.$path) || isset($_GET['goto'])): 
		header('Location: '.str_replace('#', '%23', BASEPATH.$path));
		exit();
	######### Redirect to a friendlier URL if the current one is dirty and friendly URLs has been enabled
	elseif (isset($_GET['s']) && strlen($_GET['s']) < 1 && $useFURL):
		header('Location: '.$queryURL.$path.(strlen($_GET['s']) > 0 ? '?s='.$_GET['s'].'&o='.$_GET['o'] :''));
		exit();
	endif;

	## Explode requested path into breadcrumbs
	$bc_reqpath = explode('/', trim($path, '/'));
	if (empty($bc_reqpath[0])): $breadcrumb_path = array(); else:
	foreach ($bc_reqpath as $key => $bc):
		$breadcrumb_path[$key] = array($bc, '');
		for ($i = 0; $i <= $key; ++$i)
			$breadcrumb_path[$key][1] .= '/'.$bc_reqpath[$i];
		$breadcrumb_path[$key][1] .= '/';
	endforeach; endif;

## }}} RETRIEVE AND SET PATH VARIABLES

## Sorting options: alphabetical/date/filesize (default is by name)
foreach ($columns as $col) if (isset($_GET[$col])) $sort_by = $col;
if (empty($sort_by)) $sort_by = $columns[0];
// Ascending/descending sorting(default is ascending)
$sort_order = (isset($_GET['desc']) ? 'desc' : 'asc');

// Available search options
$search['options_available'] = array('ic' => 'in current', 'fc' => 'from current');

######### Start execution time counting
execution_time();

######### Include administrator addons if enabled
if ($admin && !@file_exists(dirname(__FILE__).'/phpFe_admin.php')):
	$msg[] = "ERROR: Could not include administrator addons.";
	$admin = false;
elseif($admin):
	include dirname(__FILE__).'/phpFe_admin.php';
endif;

######### Create objects array
$objects = array();

## {{{ SEARCH FOR FILES/DIRECTORIES
## Search in/from current directory for objects mathing the search pattern
// Clean up the search pattern
$search['string'] = urldecode(trim($_GET['s']));
if ((!empty($search['string']) || $search['string'] == '0') && $search['enabled']):

	// Determine whether to do a recursive search or not
	$search['recursive'] = $_GET['o'] == 'fc' ? true : false;
	// Directories to search(will be updated if the search is recursive
	$searchdirs = array($path);

	## {{{ Open each directory requested
	for ($i = 0; $i < count($searchdirs); ++$i):
		// Attempt to open directory
		$d = @opendir(dROOT.BASEPATH.$searchdirs[$i]);
		if (!$d) continue;
		## {{{ Parse current directory
		while ((false !== $object = @readdir($d))):
			// Skip references to current and previous folder along with any excluded objects
			if ($object == '.' || $object == '..' || is_excluded($searchdirs[$i].$object)) continue;
			// Check if object matches the pattern using either RegEx or a normal string search
			if ( ($search['regex'] && preg_match('~'.preg_quote($search['string'], '~').'~i', $object)) || (!$search['regex'] && strpos($object, $search['string']) !== false) )
				$objects[] = $searchdirs[$i].$object; // Add object to list
			// Current entry is a directory
			if (@is_dir(dROOT.BASEPATH.$searchdirs[$i].$object) && $search['recursive']):
				// Search directory and add any matches inside it
				$searchdirs[] = $searchdirs[$i].$object.'/';
			endif;
		endwhile;
		## }}} Parse current directory
		@closedir($d);
	endfor;
	## }}} Open each directory requested

	// Notify if no objects matching the pattern could be found
	if (count($objects) < 1)
		$msg[] = "Could not find any objects matching the search pattern.";

	// Add search to breadcrumb path
	$breadcrumb_path[] = array('Search: '.$search['string'], $path);

## }}} SEARCH FOR FILES/DIRECTORIES
## {{{ LIST DIRECTORY
## Parse contents of current directory
else:

	## {{{ Open requested directory
	if (($dir = @opendir(dROOT.BASEPATH.$path)) && !is_excluded($path)):

		// Add objects which are not excluded to the list
		while (false !== ($object = @readdir($dir)))
			if ($object != '.' && $object != '..' && !is_excluded($path.$object))
				$objects[] = $path.$object;
		
		@closedir($dir);

		// Notify if no objects could be found
		if (@count($objects) < 1):
			$msg[] = "Could not find any objects in the directory.";
		endif;

	## }}} Open requested directory
	## Errors occurred attempting to open
	else: $msg[] = "Could not open directory.";
	endif;

endif;
## }}} LIST DIRECTORY


## {{{ PARSE OBJECTS
## Parse each object and generate table data

// Index variables
$fnum = 0;
$dnum = 0;
$dirs = array();
$files = array();

// Total filesize of all files listed
$total_filesize = 0;

## Parse objects if the array is valid
if (is_array($objects)):
	
	## {{{ Loop trough each object
	foreach ($objects as $num => $object):

		// Clear temporary data for previous object
		$current = null;

		// Extract name for the object
		$obj_name = obname($object);

		// Set absolute path to current object
		$obj_path = dROOT.BASEPATH.$object;

		## {{{ Current object is a directory
		if (@is_dir($obj_path)):

			#### Set new data
			$current = array(
				'name' => $obj_name, // Directory name
				'path' => $object.'/', // Path to directory
				'size' => 0,
				'size_disp' => 'N/A',
				'type' => 'dir', // Filetype
				'date' => @filemtime($obj_path), // Last edit
				'date_disp' => date($timeFormat, @filemtime($obj_path)) // Readable date
			);
			// Increase index
			++$dnum;
			// Add current directory to the list
			$dirs[] = $current;

		## }}} Current object is a directory
		## {{{ Current object is a file
		else:

			#### Set new data
			$current = array(
				'name' => $obj_name, // Filename
				'path' => $object, // Path to file
				'size' => @filesize($obj_path), // Filesize
				'size_disp' => convert_filesize(@filesize($obj_path)), // Readable filesize
				'type' => (strrpos($obj_name, '.') !== false ? strtolower(substr($obj_name, strrpos($obj_name, '.')+1)) : 'N/A'), // Filetype
				'date' => @filemtime($obj_path), // Last edit
				'date_disp' => date($timeFormat, @filemtime($obj_path)) // Readable date
			);
			// Add current files size to total filesize
			$total_filesize += $current['size'];
			// Increase index
			++$fnum;
			// Add current file to the list
			$files[] = $current;

		endif;
		## }}} Current object is a file

	endforeach;
	## }}} Loop trough each object

	## Sort objects
	$col_sort = create_function(($sort_order=='desc'?'$b,$a':'$a,$b'), "\$cmp = strnatcasecmp(\$a['$sort_by'],\$b['$sort_by']); return(\$cmp!=0 ? \$cmp : strnatcasecmp(\$a['name'],\$b['name']));");
	if (is_array($files)) usort($files, $col_sort);
	if (is_array($dirs)) usort($dirs, $col_sort);

endif; // Valid object array check
## }}} Parse objects


## {{{ Var dumping
if (isset($_GET['dump']))
	$msg[] = "\$_SERVER['REQUEST_URI']: {$_SERVER['REQUEST_URI']}<br />\$_SERVER['QUERY_STRING']: {$_SERVER['QUERY_STRING']}<br />\$_GET['p']: {$_GET['p']}<br />\$_SERVER['PATH_INFO']: {$_SERVER['PATH_INFO']}<br />BASEPATH: ".BASEPATH."<br />dROOT: ".dROOT."<br />\$path: $path";
## }}} Var dumping

## {{{ execution_time
## Calculate execution time after first call
function execution_time($digits = 5, $reset = false) {
	// Save starting time for later function call
	static $start;
	// Get current time
	$nowp = @explode(' ', microtime());
	$now = (double)$nowp[0] + (double)$nowp[1];
	// Set starting time
	if (!$start || $reset): 
		$start = $now;
		return $start;
	endif;
	// Return execution time if starting time has already been set
	return substr($now - $start, 0, $digits);
} ## }}} execution_time

## {{{ is_excluded
## Check exclusion list for a regex match for $path
function is_excluded($path) {
	if (!is_array($GLOBALS['excludes'])) return false;
	foreach ($GLOBALS['excludes'] as $pattern)
		if (preg_match('~'.$pattern.'~i', $path)) return true;
	return false;
} ## }}} is_excluded

## {{{ obname
## Extract the file or folder name out of the provided path
function obname($path) {
	if (empty($path) && $path != '0') return '';
	return preg_replace('~^(.*?)[\\/]?([^\\/:\*\?]+)[\\/]?(\?.*)?$~', '\\2', $path);
} ## }}} obname

## {{{ convert_filesize
## Convert filesize in bytes to human-readable size
function convert_filesize($bytes) {
	switch ($bytes):
		case '': return '0 B'; break;
		case $bytes >= pow(2,40): return round($bytes / pow(1024,4), 2).' TB'; break;
		case $bytes >= pow(2,30): return round($bytes / pow(1024,3), 2).' GB'; break;
		case $bytes >= pow(2,20): return round($bytes / pow(1024,2), 2).' MB'; break;
		case $bytes >= pow(2,10): return round($bytes / pow(1024,1), 2).' KB'; break;
		default: return $bytes.' B';
	endswitch;
} ## }}} convert_filesize

## {{{ entity
## Convert special characters to html entities
function entity($string) {
	return htmlspecialchars($string, ENT_QUOTES);
} ## }}} entity

## {{{ req_url
## Return URL leading to the requested path and if specified, additional sorting arguments
function req_url($newpath, $sort = false, $order = false, $searching = true) {
	global $sort_by, $sort_order, $path, $useFURL, $queryURL, $useRelURLs;
	$newpath = (!isset($newpath) || $newpath == $path ? $path : preg_replace('~[^\/]*\/+\.\.[\/]?~', '', $newpath));
	if (defined('NONAV')) return $newpath;
	// Determine sort parameters
	if ($sort != false):
		$sort = (!empty($sort) ? $sort : $sort_by);
		$order = ($order != false ? $order : ($sort_order != 'desc' && $sort == $sort_by ? 'desc' : 'asc'));
	else:
		$sort = $sort_by;
		$order = $sort_order;
	endif;
	// Add search parameters if we're still linking to the same page
	$search = ($newpath == $path && $searching != false && strlen($_GET['s']) > 0 ? 's='.$_GET['s'].'&o='.$_GET['o'].'&' :'');
	// Construct the URL
	$ret_args = (!$useFURL ? 'p='.str_replace('%23', '%2523', urlencode($newpath)).'&' :'').($sort != 'name' ? $sort.'&' :'').($order != 'asc' ? 'desc&' :'').$search;
	$isrelative = ( ($useRelURLs && preg_match('~^'.preg_quote($path, '~').'~', $newpath) && $newpath != $path) ? true : false);
	return entity( (!$isrelative ? $queryURL :'').str_replace('#', '%2523', ($useFURL ? ($isrelative ? preg_replace('~^('.preg_quote($path, '~').')~', '', $newpath) : $newpath) :'')).(!empty($ret_args) ? '?'.substr($ret_args, 0, strrpos($ret_args, '&')) :'') );
} ## }}} req_url

if (!function_exists('output_list')):
## {{{ output_list
## Output object list table data
function output_list(&$list, $is_dirs = false) {
	global $columns;
	if (count($list) < 1) return false;
	// Output each objects data
	foreach ($list as $num => $obj):
		echo "<tr class='".($is_dirs?'d':'f ft_'.$obj['type'])."'>";
		foreach ($columns as $num => $col):
			if ($num == 0) echo "<td class='n'><a href='".req_url($obj['path'])."' title='".entity($obj['path'])."'>".$obj[$col]."</a></td>";
			else echo "<td>".(isset($obj[$col.'_disp'])?$obj[$col.'_disp']:$obj[$col])."</td>";
		endforeach;
		echo "</tr>\n";
	endforeach;
} ## }}} output_list
endif;

#### Turn short tags on for use below
ini_set('short_open_tag', 'On');
?>
<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>
<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en'>

<head>
	<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1' />
	<meta name='description' content='Listing <?php echo($path!='/'?entity($path):'/root')?>' />
	<title><?php echo($path!='/'?entity($path):'/root')?></title>
	<link rel='stylesheet' type='text/css' href='<?php echo $folder_path?>/css/phpFe.css' />
<?php if ($admin) echo "\t<link rel='stylesheet' type='text/css' href='{$folder_path}/css/phpFe_admin.css' />\n"; ?>
	<!--[if lte IE 7]><link rel='stylesheet' type='text/css' href='<?php echo $folder_path?>/css/phpFe_ie.css' title='phpFe_ie'><![endif]-->
<?php if ($admin) echo "\t<script type='text/javascript' src='{$folder_path}/phpFe_admin.js'></script>\n"; ?>
</head>

<body id='phpFe'>
<div id='wrapper'>

<?php
######### Write admin pre table output if logged in
if ($admin) admin_pre_table(); ?>
<div class='box' id='list'>
<table class='fetable'>
<caption id='cfolder'><a href='<?php echo req_url('/')?>'>root</a><?php foreach ($breadcrumb_path as $bc): ?> &#8250; <a href='<?php echo req_url($bc[1],false,false,false) ?>'><?php echo $bc[0]?></a><?php endforeach ?></caption>

<thead><tr>
<?php if ($admin) admin_firstcol();
foreach ($columns as $col) echo "\t<th id='col_{$col}'".($sort_by==$col?" class='".$sort_order." active'":'')."><a href='".req_url($path,$col)."' title='Sort by {$col}'>".ucfirst($col)."</a></th>\n"; ?>
</tr></thead>

<tfoot><tr>
	<td id='about'<?php if ($admin): ?> colspan='2'<?php endif ?>><a href='http://mogel.nu' title='Visit author website'>phpFe v<?php echo PHPFE_VERSION?></a></td>
<?php
	if (isset($columns[2])) echo "	<td id='total_list'>~ ".($dnum+$fnum)."</td>\n";
	if (isset($columns[3])) echo "	<td id='total_filesize'>".convert_filesize($total_filesize)."</td>\n";
	echo "	<td id='execution_time'>~ <em>".execution_time()." s</em></td>\n";
?>
</tr></tfoot>

<tbody>

<?php
######### Output messages generated during the execution if there are any
if (count($msg) > 0): ?>	<tr class='message'><td colspan='<?php echo($admin?count($columns)+1:count($columns))?>'><?php foreach ($msg as $num => $message): if ($num != 0) echo "<br />"; echo $message; endforeach; ?></td></tr>
<?php endif;
######### List directories & files
if ($sort_order != 'desc' || defined('DIRS_FIRST')):
	output_list($dirs, true);
	output_list($files, false);
else:
	output_list($files, false);
	output_list($dirs, true);
endif;
?>

</tbody>

</table>
</div>

<?php
######### Write admin post table output if logged in
if ($admin) admin_post_table();

## {{{ Output search form if enabled
if ($search['enabled']):
?>
<form method='get' action='<?php echo entity($_SERVER['REQUEST_URI']) ?>' id='form_actions' class='ext_form'>
<div class='box' id='goto_box'>
<h2><label for='goto'>Goto</label></h2>
	<fieldset id='form_goto'>
		<input type='text' class='textbox' name='p' id='goto' title='Goto path' value='<?php echo $path ?>' />
		<input type='submit' class='button' id='submit_goto' value='Goto' />
	</fieldset>
</div>
<div class='box' id='search_box'>
<h2><label for='search'>Search</label></h2>
	<fieldset id='form_search'>
		<input type='text' class='textbox' name='s' id='search' title='Search for files and folders matching pattern' value='<?php echo $_GET['s'] ?>' />
		<select name='o' id='search_options' title='Search options' size='1'>
<?php foreach ($search['options_available'] as $value => $title)  echo "\t\t\t<option value='{$value}'".(isset($_GET['o']) && $_GET['o']==$value?"selected='selected'":'').">{$title}</option>\n"; ?>
		</select>
		<input type='submit' class='button' id='submit_search' value='Search' />
	</fieldset>
</div>
</form>
<?php
endif; ## }}}
?>

</div>
</body>
<!-- Executed in <?php echo execution_time(); ?> seconds -->
</html>
